/****** Object:  StoredProcedure [dbo].[P_EST_NF_ENT_ANALISE_ENTRADA_VALORES_EXECUTE_ALL]    Script Date: 11/07/2013 18:13:23 ******/
IF EXISTS( SELECT * FROM sys.objects
				WHERE  object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_ANALISE_ENTRADA_VALORES_EXECUTE_ALL]')
					   AND type IN(N'P', N'PC')
)
	BEGIN
		DROP PROCEDURE [dbo].[P_EST_NF_ENT_ANALISE_ENTRADA_VALORES_EXECUTE_ALL];
	END;
GO
GO
GO
--EXEC P_EST_NF_ENT_ANALISE_ENTRADA_VALORES_EXECUTE_ALL 0,'2018-01-01','2018-06-08'

CREATE PROCEDURE [dbo].[P_EST_NF_ENT_ANALISE_ENTRADA_VALORES_EXECUTE_ALL] @CD_FILIAL_PAR INT      = 0
																		, @DT_INI AS        DATETIME=NULL
																		, @DT_FIM AS DATETIME=NULL
AS
	 BEGIN
		 PRINT 'Inicio da analise de entradas de produtos';
		 SET NOCOUNT ON;
		 DECLARE @CD_FILIAL INT;
		 DECLARE @CD_EMP INT;
		 DECLARE @DTINI DATETIME;
		 DECLARE @DTFIM DATETIME

		 IF @DT_INI IS NULL
		 BEGIN
			SET @DTINI=CONVERT(CHAR(10),GETDATE()-4,112)
			SET @DTFIM=CONVERT(CHAR(10),GETDATE(),112)
		 END
		 ELSE
		 BEGIN
			SET @DTINI=@DT_INI
			SET @DTFIM=@DT_FIM
		 END

		PRINT 'Periodo '+ CONVERT(CHAR(10), @DTINI,112)+ ' a '+ CONVERT(CHAR(10), @DTFIM,112) +' '+CONVERT(VARCHAR(10), GETDATE(), 108);

		 DECLARE ProcAnaliseEntradaProdutos CURSOR FAST_FORWARD
		 FOR SELECT
					CD_EMP
				  , CD_FILIAL
			 FROM
				 PRC_FILIAL
			 WHERE  CD_FILIAL = CASE
									WHEN @CD_FILIAL_PAR > 0 THEN @CD_FILIAL_PAR
									ELSE CD_FILIAL
								END;



		 OPEN ProcAnaliseEntradaProdutos;
		 FETCH NEXT FROM ProcAnaliseEntradaProdutos INTO @CD_EMP
											  , @CD_FILIAL;
		 WHILE @@FETCH_STATUS = 0
			 BEGIN
				 PRINT 'Filial '+CONVERT(VARCHAR(10), @CD_FILIAL)+' '+CONVERT(VARCHAR, GETDATE(), 108);


				 EXEC P_EST_NF_ENT_ANALISE_ENTRADA_VALORES @CD_EMP,@CD_FILIAL,0,0,@DTINI,@DTFIM

				 FETCH NEXT FROM ProcAnaliseEntradaProdutos INTO @CD_EMP
													  , @CD_FILIAL;
			 END;
		 PRINT 'Concluido.';
		 CLOSE ProcAnaliseEntradaProdutos;
		 DEALLOCATE ProcAnaliseEntradaProdutos;
	 END;